﻿// USB_NIKKI_Tower_DLL_Sample_Code_CS
using System;
using System.Runtime.InteropServices;
using System.Text;
partial class Parameter
{
    //Status
    public const int Status_Set = 1;
    public const int Status_Reset = 2;
    public const int Status_Get_Firmware = 3;
    // Red LED Status
    public const int RLED_Mode0 = 0;
    public const int RLED_Mode1 = 1;
    public const int RLED_Mode2 = 2;
    public const int RLED_Mode3 = 3;
    public const int RLED_Mode4 = 4;
    public const int RLED_Mode5 = 5;
    public const int RLED_Mode6 = 6;
    public const int RLED_Keep = 7;
    // Yellow LED Status
    public const int YLED_Mode0 = 0;
    public const int YLED_Mode1 = 1;
    public const int YLED_Mode2 = 2;
    public const int YLED_Mode3 = 3;
    public const int YLED_Mode4 = 4;
    public const int YLED_Mode5 = 5;
    public const int YLED_Mode6 = 6;
    public const int YLED_Keep = 7;
    // Green LED Status
    public const int GLED_Mode0 = 0;
    public const int GLED_Mode1 = 1;
    public const int GLED_Mode2 = 2;
    public const int GLED_Mode3 = 3;
    public const int GLED_Mode4 = 4;
    public const int GLED_Mode5 = 5;
    public const int GLED_Mode6 = 6;
    public const int GLED_Keep = 7;
    // Blue LED Status
    public const int BLED_Mode0 = 0;
    public const int BLED_Mode1 = 1;
    public const int BLED_Mode2 = 2;
    public const int BLED_Mode3 = 3;
    public const int BLED_Mode4 = 4;
    public const int BLED_Mode5 = 5;
    public const int BLED_Mode6 = 6;
    public const int BLED_Keep = 7;
    // White LED Status
    public const int WLED_Mode0 = 0;
    public const int WLED_Mode1 = 1;
    public const int WLED_Mode2 = 2;
    public const int WLED_Mode3 = 3;
    public const int WLED_Mode4 = 4;
    public const int WLED_Mode5 = 5;
    public const int WLED_Mode6 = 6;
    public const int WLED_Keep = 7;
    // Buzzer Volume
    public const int Volume1 = 1;
    public const int Volume2 = 2;
    public const int Volume3 = 3;
    public const int Volume4 = 4;
    public const int Vol_Keep = 5;
    // Buzzer Mode
    public const int Buz_Mode0 = 0;
    public const int Buz_Mode1 = 1;
    public const int Buz_Mode2 = 2;
    public const int Buz_Mode3 = 3;
    public const int Buz_Mode4 = 4;
    public const int Buz_Mode5 = 5;
    public const int Buz_Mode6 = 6;
    public const int Buz_Keep7 = 7;
    // Buzzer Frequency 1
    public const int Buz_F1_OFF = 1;
    public const int Buz_F1_1760 = 2;
    public const int Buz_F1_1864_7 = 3;
    public const int Buz_F1_1975_5 = 4;
    public const int Buz_F1_2093 = 5;
    public const int Buz_F1_2217_5 = 6;
    public const int Buz_F1_2349_3 = 7;
    public const int Buz_F1_2489 = 8;
    public const int Buz_F1_2637 = 9;
    public const int Buz_F1_2793_8 = 10;
    public const int Buz_F1_2960 = 11;
    public const int Buz_F1_3136 = 12;
    public const int Buz_F1_3322_4 = 13;
    public const int Buz_F1_3520 = 14;
    // Buzzer Frequency 2
    public const int Buz_F2_OFF = 1;
    public const int Buz_F2_1760 = 2;
    public const int Buz_F2_1864_7 = 3;
    public const int Buz_F2_1975_5 = 4;
    public const int Buz_F2_2093 = 5;
    public const int Buz_F2_2217_5 = 6;
    public const int Buz_F2_2349_3 = 7;
    public const int Buz_F2_2489 = 8;
    public const int Buz_F2_2637 = 9;
    public const int Buz_F2_2793_8 = 10;
    public const int Buz_F2_2960 = 11;
    public const int Buz_F2_3136 = 12;
    public const int Buz_F2_3322_4 = 13;
    public const int Buz_F2_3520 = 14;

}
partial class DLL_Function
{
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int Start_HID();
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int Stop_HID();
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int Buzzer_Control(int mode, int frequency1, int frequency2, int volume);
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int Buzzer_Off();
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr Get_Dll_Version();
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr Get_Firmware_Version(IntPtr buffer, int buffer_size);
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int LED_Control(int Red, int Yellow, int Green, int Blue, int White);
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int Led_All_Off();
    [DllImport("USB_Nikki_Tower.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int Reset_Device();
}
partial class Program
{
    static void Main()
    {
        int result = DLL_Function.Start_HID();
        Console.WriteLine(result);
        int succ = 0;
        if (result == 0)
        {
            while (true)
            {
                Console.WriteLine("=== Mode Select ===");
                Console.WriteLine("1. LED_Control");
                Console.WriteLine("2. LED_All_Off");
                Console.WriteLine("3. Buzzer_Control");
                Console.WriteLine("4. Buzzer_Off");
                Console.WriteLine("5. Reset_Device");
                Console.WriteLine("6. Get_Firmware_Version");
                Console.WriteLine("7. Get_DLL_Version");
                Console.WriteLine("8. Stop_HID");
                string input = Console.ReadLine();
                switch (input)
                {
                    case "1":
                        succ = DLL_Function.LED_Control(Parameter.RLED_Mode1, Parameter.YLED_Mode2, Parameter.GLED_Mode4, Parameter.BLED_Mode3, Parameter.WLED_Mode5);
                        Console.WriteLine(succ);
                        break;

                    case "2":
                        succ = DLL_Function.Led_All_Off();
                        Console.WriteLine(succ);
                        break;

                    case "3":
                        succ = DLL_Function.Buzzer_Control(Parameter.Buz_Mode3, Parameter.Buz_F1_1864_7, Parameter.Buz_F2_2793_8, Parameter.Volume3);
                        Console.WriteLine(succ);
                        break;
                    case "4":
                        succ = DLL_Function.Buzzer_Off();
                        Console.WriteLine(succ);
                        break;
                    case "5":
                        succ = DLL_Function.Reset_Device();
                        Console.WriteLine(succ);
                        break;
                    case "6":
                        int bufferSize = 256;
                        byte[] buffer = new byte[bufferSize];

                        GCHandle handle = GCHandle.Alloc(buffer, GCHandleType.Pinned);
                        IntPtr bufferPtr = handle.AddrOfPinnedObject();
                        try
                        {
                            IntPtr retPtr = DLL_Function.Get_Firmware_Version(bufferPtr, bufferSize);

                            string resultStr = Marshal.PtrToStringAnsi(retPtr);

                            if (resultStr == "-3")
                            {
                                Console.WriteLine("ERR_CONNECTION");
                            }
                            else if (resultStr == "-7")
                            {
                                Console.WriteLine("ERR_FIRMRECV_FAIL");
                            }
                            else
                            {
                                Console.Write("Firmware version (hex): ");

                                for (int i = 0; i < 8; i++)
                                {
                                    Console.Write($"{buffer[i]:X2} ");
                                }

                                Console.WriteLine();
                            }
                        }
                        finally
                        {
                            handle.Free();
                        }
                        break;
                    case "7":
                        IntPtr ptr = DLL_Function.Get_Dll_Version();
                        string DLLVer = Marshal.PtrToStringAnsi(ptr);
                        Console.WriteLine("DLL Version: " + DLLVer);
                        break;
                    case "8":
                        succ = DLL_Function.Stop_HID();
                        Console.WriteLine(succ);
                        break;
                    default:
                        Console.WriteLine("Error Parameters");
                        break;
                }
            }
        }
        Console.ReadLine();
    }
}
