﻿'USB_NIKKI_Tower_DLL_Sample_Code_VB'
Imports System
Imports System.Reflection.Metadata
Imports System.Runtime.InteropServices
Imports System.Text
Module Parameter

    'Status'
    Public Const Status_Set As Integer = 1
    Public Const Status_Reset As Integer = 2
    Public Const Status_Get_Firmware As Integer = 3
    'Red LED Status'
    Public Const RLED_Mode0 As Integer = 0
    Public Const RLED_Mode1 As Integer = 1
    Public Const RLED_Mode2 As Integer = 2
    Public Const RLED_Mode3 As Integer = 3
    Public Const RLED_Mode4 As Integer = 4
    Public Const RLED_Mode5 As Integer = 5
    Public Const RLED_Mode6 As Integer = 6
    Public Const RLED_Keep As Integer = 7
    'Yellow LED Status'
    Public Const YLED_Mode0 As Integer = 0
    Public Const YLED_Mode1 As Integer = 1
    Public Const YLED_Mode2 As Integer = 2
    Public Const YLED_Mode3 As Integer = 3
    Public Const YLED_Mode4 As Integer = 4
    Public Const YLED_Mode5 As Integer = 5
    Public Const YLED_Mode6 As Integer = 6
    Public Const YLED_Keep As Integer = 7
    'Green LED Status'
    Public Const GLED_Mode0 As Integer = 0
    Public Const GLED_Mode1 As Integer = 1
    Public Const GLED_Mode2 As Integer = 2
    Public Const GLED_Mode3 As Integer = 3
    Public Const GLED_Mode4 As Integer = 4
    Public Const GLED_Mode5 As Integer = 5
    Public Const GLED_Mode6 As Integer = 6
    Public Const GLED_Keep As Integer = 7
    'Blue LED Status'
    Public Const BLED_Mode0 As Integer = 0
    Public Const BLED_Mode1 As Integer = 1
    Public Const BLED_Mode2 As Integer = 2
    Public Const BLED_Mode3 As Integer = 3
    Public Const BLED_Mode4 As Integer = 4
    Public Const BLED_Mode5 As Integer = 5
    Public Const BLED_Mode6 As Integer = 6
    Public Const BLED_Keep As Integer = 7
    'White LED Status'
    Public Const WLED_Mode0 As Integer = 0
    Public Const WLED_Mode1 As Integer = 1
    Public Const WLED_Mode2 As Integer = 2
    Public Const WLED_Mode3 As Integer = 3
    Public Const WLED_Mode4 As Integer = 4
    Public Const WLED_Mode5 As Integer = 5
    Public Const WLED_Mode6 As Integer = 6
    Public Const WLED_Keep As Integer = 7
    'Buzzer Volume'
    Public Const Volume1 As Integer = 1
    Public Const Volume2 As Integer = 2
    Public Const Volume3 As Integer = 3
    Public Const Volume4 As Integer = 4
    Public Const Vol_Keep As Integer = 5
    'Buzzer Mode'
    Public Const Buz_Mode0 As Integer = 0
    Public Const Buz_Mode1 As Integer = 1
    Public Const Buz_Mode2 As Integer = 2
    Public Const Buz_Mode3 As Integer = 3
    Public Const Buz_Mode4 As Integer = 4
    Public Const Buz_Mode5 As Integer = 5
    Public Const Buz_Mode6 As Integer = 6
    Public Const Buz_Keep7 As Integer = 7
    'Buzzer Frequency 1'
    Public Const Buz_F1_OFF As Integer = 1
    Public Const Buz_F1_1760 As Integer = 2
    Public Const Buz_F1_1864_7 As Integer = 3
    Public Const Buz_F1_1975_5 As Integer = 4
    Public Const Buz_F1_2093 As Integer = 5
    Public Const Buz_F1_2217_5 As Integer = 6
    Public Const Buz_F1_2349_3 As Integer = 7
    Public Const Buz_F1_2489 As Integer = 8
    Public Const Buz_F1_2637 As Integer = 9
    Public Const Buz_F1_2793_8 As Integer = 10
    Public Const Buz_F1_2960 As Integer = 11
    Public Const Buz_F1_3136 As Integer = 12
    Public Const Buz_F1_3322_4 As Integer = 13
    Public Const Buz_F1_3520 As Integer = 14
    'Buzzer Frequency 2'
    Public Const Buz_F2_OFF As Integer = 1
    Public Const Buz_F2_1760 As Integer = 2
    Public Const Buz_F2_1864_7 As Integer = 3
    Public Const Buz_F2_1975_5 As Integer = 4
    Public Const Buz_F2_2093 As Integer = 5
    Public Const Buz_F2_2217_5 As Integer = 6
    Public Const Buz_F2_2349_ As Integer = 7
    Public Const Buz_F2_2489 As Integer = 8
    Public Const Buz_F2_2637 As Integer = 9
    Public Const Buz_F2_2793_8 As Integer = 10
    Public Const Buz_F2_2960 As Integer = 11
    Public Const Buz_F2_3136 As Integer = 12
    Public Const Buz_F2_3322_4 As Integer = 13
    Public Const Buz_F2_3520 As Integer = 14

End Module
Module DLL_Function

    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Start_HID() As Integer

    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Stop_HID() As Integer
    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Buzzer_Control(mode As Integer, frequency1 As Integer, frequency2 As Integer, vol As Integer) As Integer
    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Buzzer_Off() As Integer
    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Get_Dll_Version() As Integer
    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Get_Firmware_Version(
    buffer As IntPtr,
    buffer_size As Integer) As IntPtr
    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function LED_Control(Red As Integer, Yellow As Integer, Green As Integer, Blue As Integer, White As Integer) As Integer
    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Led_All_Off() As Integer
    End Function
    <DllImport("USB_Nikki_Tower.dll", CallingConvention:=CallingConvention.Cdecl, CharSet:=CharSet.Ansi)>
    Public Function Reset_Device() As Integer
    End Function
End Module
Module Module1

    Sub Main()
        Dim result As Integer
        Dim succ As Integer
        result = Start_HID()
        Console.WriteLine(result)
        While result = 0
            Console.WriteLine("=== 功能選單 ===")
            Console.WriteLine("1. LED_Control")
            Console.WriteLine("2. LED_All_Off")
            Console.WriteLine("3. Buzzer_Control")
            Console.WriteLine("4. Buzzer_Off")
            Console.WriteLine("5. Reset_Device")
            Console.WriteLine("6. Get_Firmware_Version")
            Console.WriteLine("7. Get_DLL_Version")
            Console.WriteLine("8. Stop_HID")
            Dim input As String = Console.ReadLine()

            Select Case input
                Case "1"
                    succ = LED_Control(RLED_Mode3, YLED_Mode1, GLED_Mode2, BLED_Mode3, WLED_Mode5)
                    Console.WriteLine(succ)
                Case "2"
                    succ = Led_All_Off()
                    Console.WriteLine(succ)
                Case "3"
                    succ = Buzzer_Control(Buz_Mode3, Buz_F1_1864_7, Buz_F2_2793_8, Volume4)
                    Console.WriteLine(succ)
                Case "4"
                    succ = Buzzer_Off()
                    Console.WriteLine(succ)
                Case "5"
                    succ = Reset_Device()
                    Console.WriteLine(succ)
                Case "6"
                    Dim bufferSize As Integer = 256
                    Dim buffer(bufferSize - 1) As Byte

                    Dim handle As GCHandle = GCHandle.Alloc(buffer, GCHandleType.Pinned)
                    Dim bufferPtr As IntPtr = handle.AddrOfPinnedObject()
                    Try
                        Dim retPtr As IntPtr = Get_Firmware_Version(bufferPtr, bufferSize)
                        Dim resultStr As String = Marshal.PtrToStringAnsi(retPtr)

                        If resultStr = "-3" Then
                            Console.WriteLine("ERR_CONNECTION")
                        ElseIf resultStr = "-7" Then
                            Console.WriteLine("ERR_FIRMRECV_FAIL")
                        Else
                            Console.Write("Firmware Version (hex): ")
                            For i As Integer = 0 To 7
                                Console.Write($"{buffer(i):X2} ")
                            Next
                            Console.WriteLine()
                        End If
                    Finally
                        handle.Free()
                    End Try
                Case "7"
                    Dim ptr1 As IntPtr = DLL_Function.Get_Dll_Version()
                    Dim DLLVer As String = Marshal.PtrToStringAnsi(ptr1)
                    Console.WriteLine("DLL Version: " + DLLVer)
                Case "8"
                    succ = Stop_HID()
                    Console.WriteLine(succ)
                    Dim empty1 As String = Console.ReadLine()
                    Return
                Case Else
                    Console.WriteLine("無效選項")
            End Select
        End While
        Dim empty As String = Console.ReadLine()
    End Sub

End Module
